<?php
/**
 * Export Page
 * Halaman untuk mengexport hasil prediksi
 */

// Mengimpor file konfigurasi
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../controller/prediction_controller.php';

// Cek status login
redirectIfNotLoggedIn();

// Dapatkan model ID dari parameter URL
$modelId = isset($_GET['model_id']) ? (int) $_GET['model_id'] : null;

// Proses export
handleExport($modelId);

// Jika export gagal, redirect ke halaman hasil
header('Location: /view/prediction/result.php' . ($modelId ? '?model_id=' . $modelId : ''));
exit;