<?php
/**
 * Visualize
 * File ini berisi fungsi-fungsi untuk memvisualisasikan data
 * untuk digunakan dengan Chart.js
 */

/**
 * Memformat data untuk chart harga saham
 * 
 * @param array $data Data saham
 * @return array Data yang diformat untuk chart
 */
function formatStockChartData($data) {
    $chartData = [
        'labels' => [],
        'datasets' => [
            [
                'label' => 'Harga Penutupan',
                'data' => [],
                'borderColor' => 'rgba(75, 192, 192, 1)',
                'backgroundColor' => 'rgba(75, 192, 192, 0.2)',
                'borderWidth' => 1,
                'fill' => false
            ]
        ]
    ];
    
    foreach ($data as $row) {
        $chartData['labels'][] = $row['date'];
        $chartData['datasets'][0]['data'][] = $row['close'];
    }
    
    return $chartData;
}

/**
 * Memformat data untuk chart perbandingan harga aktual vs prediksi
 * 
 * @param array $predictions Data prediksi
 * @return array Data yang diformat untuk chart
 */
function formatPredictionChartData($predictions) {
    $chartData = [
        'labels' => [],
        'datasets' => [
            [
                'label' => 'Harga Aktual',
                'data' => [],
                'borderColor' => 'rgba(75, 192, 192, 1)',
                'backgroundColor' => 'rgba(75, 192, 192, 0.2)',
                'borderWidth' => 1,
                'fill' => false
            ],
            [
                'label' => 'Harga Prediksi',
                'data' => [],
                'borderColor' => 'rgba(255, 99, 132, 1)',
                'backgroundColor' => 'rgba(255, 99, 132, 0.2)',
                'borderWidth' => 1,
                'fill' => false
            ]
        ]
    ];
    
    foreach ($predictions as $prediction) {
        $chartData['labels'][] = $prediction['date'];
        $chartData['datasets'][0]['data'][] = $prediction['actual_price'];
        $chartData['datasets'][1]['data'][] = $prediction['predicted_price'];
    }
    
    return $chartData;
}

/**
 * Memformat data untuk chart OHLC (candlestick)
 * 
 * @param array $data Data saham
 * @return array Data yang diformat untuk chart OHLC
 */
function formatOHLCChartData($data) {
    $chartData = [
        'labels' => [],
        'datasets' => [
            [
                'label' => 'Harga Tertinggi',
                'data' => [],
                'borderColor' => 'rgba(0, 150, 0, 1)',
                'backgroundColor' => 'rgba(0, 0, 0, 0)',
                'borderWidth' => 1,
                'pointStyle' => 'line'
            ],
            [
                'label' => 'Harga Terendah',
                'data' => [],
                'borderColor' => 'rgba(255, 0, 0, 1)',
                'backgroundColor' => 'rgba(0, 0, 0, 0)',
                'borderWidth' => 1,
                'pointStyle' => 'line'
            ],
            [
                'label' => 'Harga Pembukaan',
                'data' => [],
                'borderColor' => 'rgba(100, 100, 100, 1)',
                'backgroundColor' => 'rgba(0, 0, 0, 0)',
                'borderWidth' => 1,
                'pointRadius' => 3
            ],
            [
                'label' => 'Harga Penutupan',
                'data' => [],
                'borderColor' => 'rgba(0, 0, 255, 1)',
                'backgroundColor' => 'rgba(0, 0, 0, 0)',
                'borderWidth' => 1,
                'pointRadius' => 3
            ]
        ]
    ];
    
    foreach ($data as $row) {
        $chartData['labels'][] = $row['date'];
        $chartData['datasets'][0]['data'][] = $row['high'];
        $chartData['datasets'][1]['data'][] = $row['low'];
        $chartData['datasets'][2]['data'][] = $row['open'];
        $chartData['datasets'][3]['data'][] = $row['close'];
    }
    
    return $chartData;
}

/**
 * Memformat data untuk chart volume perdagangan
 * 
 * @param array $data Data saham
 * @return array Data yang diformat untuk chart volume
 */
function formatVolumeChartData($data) {
    $chartData = [
        'labels' => [],
        'datasets' => [
            [
                'label' => 'Volume Perdagangan',
                'data' => [],
                'backgroundColor' => 'rgba(153, 102, 255, 0.2)',
                'borderColor' => 'rgba(153, 102, 255, 1)',
                'borderWidth' => 1
            ]
        ]
    ];
    
    foreach ($data as $row) {
        $chartData['labels'][] = $row['date'];
        $chartData['datasets'][0]['data'][] = $row['volume'];
    }
    
    return $chartData;
}

/**
 * Memformat data untuk chart error prediksi
 * 
 * @param array $predictions Data prediksi
 * @return array Data yang diformat untuk chart error
 */
function formatErrorChartData($predictions) {
    $chartData = [
        'labels' => [],
        'datasets' => [
            [
                'label' => 'Error Prediksi',
                'data' => [],
                'backgroundColor' => 'rgba(255, 159, 64, 0.2)',
                'borderColor' => 'rgba(255, 159, 64, 1)',
                'borderWidth' => 1
            ]
        ]
    ];
    
    foreach ($predictions as $prediction) {
        $chartData['labels'][] = $prediction['date'];
        $error = abs($prediction['actual_price'] - $prediction['predicted_price']);
        $chartData['datasets'][0]['data'][] = $error;
    }
    
    return $chartData;
}