<?php
/**
 * Model Stock
 * File ini berisi fungsi-fungsi terkait data saham
 */

require_once __DIR__ . '/../config/database.php';

/**
 * Menyimpan data saham dari CSV ke database
 * 
 * @param array $data Array data saham dari CSV
 * @return bool True jika berhasil, false jika gagal
 */
function saveStockData($data) {
    global $conn;
    
    // Mulai transaksi database
    mysqli_begin_transaction($conn);
    
    try {
        foreach ($data as $row) {
            $date = sanitizeInput($conn, $row['Date']);
            $open = sanitizeInput($conn, $row['Open']);
            $high = sanitizeInput($conn, $row['High']);
            $low = sanitizeInput($conn, $row['Low']);
            $close = sanitizeInput($conn, $row['Close']);
            $adjClose = sanitizeInput($conn, $row['Adj Close']);
            $volume = sanitizeInput($conn, $row['Volume']);
            
            $sql = "INSERT INTO stock_data (date, open, high, low, close, adj_close, volume) 
                    VALUES ('$date', $open, $high, $low, $close, $adjClose, $volume)";
            
            executeQuery($conn, $sql);
        }
        
        // Commit transaksi
        mysqli_commit($conn);
        return true;
    } catch (Exception $e) {
        // Rollback jika terjadi error
        mysqli_rollback($conn);
        error_log("Error saving stock data: " . $e->getMessage());
        return false;
    }
}

/**
 * Mendapatkan semua data saham
 * 
 * @param int $limit Batas jumlah data yang diambil
 * @param int $offset Offset untuk pagination
 * @return array Data saham
 */
function getAllStockData($limit = 100, $offset = 0) {
    global $conn;
    
    $sql = "SELECT * FROM stock_data ORDER BY date DESC LIMIT $limit OFFSET $offset";
    $result = executeQuery($conn, $sql);
    
    return fetchData($result);
}

/**
 * Mendapatkan jumlah total data saham
 * 
 * @return int Jumlah total data
 */
function getStockDataCount() {
    global $conn;
    
    $sql = "SELECT COUNT(*) as total FROM stock_data";
    $result = executeQuery($conn, $sql);
    $row = fetchRow($result);
    
    return $row['total'];
}

/**
 * Menghapus semua data saham
 * 
 * @return bool True jika berhasil, false jika gagal
 */
function deleteAllStockData() {
    global $conn;
    
    $sql = "TRUNCATE TABLE stock_data";
    executeQuery($conn, $sql);
    
    return true;
}

/**
 * Mendapatkan data untuk visualisasi (grafik)
 * 
 * @param int $limit Batas jumlah data yang diambil
 * @return array Data untuk visualisasi
 */
function getChartData($limit = 100) {
    global $conn;
    
    $sql = "SELECT date, open, high, low, close, volume 
            FROM stock_data 
            ORDER BY date ASC 
            LIMIT $limit";
    
    $result = executeQuery($conn, $sql);
    
    return fetchData($result);
}

/**
 * Mendapatkan data harga penutupan dan tanggal untuk model
 * 
 * @return array Data harga penutupan dan tanggal
 */
function getClosePriceData() {
    global $conn;
    
    $sql = "SELECT date, close FROM stock_data ORDER BY date ASC";
    $result = executeQuery($conn, $sql);
    
    return fetchData($result);
}

/**
 * Mendapatkan data terakhir
 * 
 * @param int $days Jumlah hari
 * @return array Data terakhir
 */
function getLatestData($days = 30) {
    global $conn;
    
    $sql = "SELECT * FROM stock_data ORDER BY date DESC LIMIT $days";
    $result = executeQuery($conn, $sql);
    
    $data = fetchData($result);
    // Balik array agar urutan menjadi dari lama ke baru
    return array_reverse($data);
}