<?php
/**
 * Model Settings
 * File ini berisi fungsi-fungsi terkait pengaturan model Random Forest
 */

require_once __DIR__ . '/../config/database.php';

/**
 * Mendapatkan pengaturan model terbaru
 * 
 * @return array Data pengaturan model
 */
function getLatestModelSettings() {
    global $conn;
    
    $sql = "SELECT * FROM model_settings ORDER BY id DESC LIMIT 1";
    $result = executeQuery($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) {
        return fetchRow($result);
    }
    
    // Jika tidak ada pengaturan, buat default
    $defaultSettings = createDefaultSettings();
    return getModelSettingsById($defaultSettings);
}

/**
 * Membuat pengaturan model default
 * 
 * @return int ID pengaturan model yang dibuat
 */
function createDefaultSettings() {
    global $conn;
    
    $sql = "INSERT INTO model_settings (train_test_ratio, n_estimators) VALUES (0.8, 100)";
    executeQuery($conn, $sql);
    
    return mysqli_insert_id($conn);
}

/**
 * Mendapatkan pengaturan model berdasarkan ID
 * 
 * @param int $id ID pengaturan model
 * @return array|false Data pengaturan model jika ditemukan, false jika tidak
 */
function getModelSettingsById($id) {
    global $conn;
    
    $sql = "SELECT * FROM model_settings WHERE id = $id";
    $result = executeQuery($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) {
        return fetchRow($result);
    }
    
    return false;
}

/**
 * Menyimpan pengaturan model baru
 * 
 * @param float $trainTestRatio Rasio data training-testing
 * @param int $nEstimators Jumlah estimator
 * @param int|null $maxDepth Kedalaman maksimal pohon
 * @param int $minSamplesSplit Jumlah sampel minimal untuk split
 * @param int $minSamplesLeaf Jumlah sampel minimal untuk leaf
 * @return int ID pengaturan model yang dibuat
 */
function saveModelSettings($trainTestRatio, $nEstimators, $maxDepth = NULL, $minSamplesSplit = 2, $minSamplesLeaf = 1) {
    global $conn;
    
    // Sanitasi input
    $trainTestRatio = floatval($trainTestRatio);
    $nEstimators = intval($nEstimators);
    $minSamplesSplit = intval($minSamplesSplit);
    $minSamplesLeaf = intval($minSamplesLeaf);
    
    // Gunakan NULL jika maxDepth kosong atau nol
    $maxDepthValue = ($maxDepth && intval($maxDepth) > 0) ? intval($maxDepth) : "NULL";
    
    $sql = "INSERT INTO model_settings (train_test_ratio, n_estimators, max_depth, min_samples_split, min_samples_leaf) 
            VALUES ($trainTestRatio, $nEstimators, $maxDepthValue, $minSamplesSplit, $minSamplesLeaf)";
    
    executeQuery($conn, $sql);
    
    return mysqli_insert_id($conn);
}

/**
 * Mendapatkan semua pengaturan model
 * 
 * @param int $limit Batas jumlah data yang diambil
 * @return array Data pengaturan model
 */
function getAllModelSettings($limit = 10) {
    global $conn;
    
    $sql = "SELECT * FROM model_settings ORDER BY created_at DESC LIMIT $limit";
    $result = executeQuery($conn, $sql);
    
    return fetchData($result);
}