<?php
/**
 * Model Prediction
 * File ini berisi fungsi-fungsi terkait prediksi saham
 */

require_once __DIR__ . '/../config/database.php';

/**
 * Menyimpan hasil prediksi
 * 
 * @param array $predictions Array hasil prediksi
 * @param int $modelId ID model yang digunakan
 * @return bool True jika berhasil, false jika gagal
 */
function savePredictions($predictions, $modelId) {
    global $conn;
    
    // Hapus prediksi sebelumnya dengan model yang sama
    $sql = "DELETE FROM predictions WHERE model_id = $modelId";
    executeQuery($conn, $sql);
    
    // Mulai transaksi database
    mysqli_begin_transaction($conn);
    
    try {
        foreach ($predictions as $prediction) {
            $date = sanitizeInput($conn, $prediction['date']);
            $actualPrice = floatval($prediction['actual_price']);
            $predictedPrice = floatval($prediction['predicted_price']);
            
            $sql = "INSERT INTO predictions (date, actual_price, predicted_price, model_id) 
                    VALUES ('$date', $actualPrice, $predictedPrice, $modelId)";
            
            executeQuery($conn, $sql);
        }
        
        // Commit transaksi
        mysqli_commit($conn);
        return true;
    } catch (Exception $e) {
        // Rollback jika terjadi error
        mysqli_rollback($conn);
        return false;
    }
}

/**
 * Menyimpan metrik evaluasi model
 * 
 * @param int $modelId ID model
 * @param float $mae Mean Absolute Error
 * @param float $rmse Root Mean Square Error
 * @return bool True jika berhasil, false jika gagal
 */
function saveModelEvaluation($modelId, $mae, $rmse) {
    global $conn;
    
    // Hapus evaluasi sebelumnya dengan model yang sama
    $sql = "DELETE FROM model_evaluation WHERE model_id = $modelId";
    executeQuery($conn, $sql);
    
    // Simpan evaluasi baru
    $sql = "INSERT INTO model_evaluation (model_id, mae, rmse) VALUES ($modelId, $mae, $rmse)";
    executeQuery($conn, $sql);
    
    return mysqli_affected_rows($conn) > 0;
}

/**
 * Mendapatkan prediksi terbaru berdasarkan model
 * 
 * @param int $modelId ID model
 * @return array Data prediksi
 */
function getPredictionsByModelId($modelId) {
    global $conn;
    
    $sql = "SELECT * FROM predictions WHERE model_id = $modelId ORDER BY date ASC";
    $result = executeQuery($conn, $sql);
    
    return fetchData($result);
}

/**
 * Mendapatkan prediksi terbaru
 * 
 * @return array Data prediksi
 */
function getLatestPredictions() {
    global $conn;
    
    $sql = "SELECT p.* FROM predictions p
            JOIN (SELECT MAX(id) as id FROM model_settings) ms
            WHERE p.model_id = ms.id
            ORDER BY p.date ASC";
    $result = executeQuery($conn, $sql);
    
    return fetchData($result);
}

/**
 * Mendapatkan evaluasi model berdasarkan ID model
 * 
 * @param int $modelId ID model
 * @return array|false Data evaluasi model jika ditemukan, false jika tidak
 */
function getModelEvaluationByModelId($modelId) {
    global $conn;
    
    $sql = "SELECT * FROM model_evaluation WHERE model_id = $modelId";
    $result = executeQuery($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) {
        return fetchRow($result);
    }
    
    return false;
}

/**
 * Mendapatkan evaluasi model terbaru
 * 
 * @return array|false Data evaluasi model jika ditemukan, false jika tidak
 */
function getLatestModelEvaluation() {
    global $conn;
    
    $sql = "SELECT me.* FROM model_evaluation me
            JOIN (SELECT MAX(id) as id FROM model_settings) ms
            WHERE me.model_id = ms.id";
    $result = executeQuery($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) {
        return fetchRow($result);
    }
    
    return false;
}