<?php
/**
 * Main Entry Point
 * File ini mengarahkan ke halaman dashboard jika sudah login
 * atau ke halaman login jika belum login
 */

// Mengimpor file konfigurasi
require_once 'config/database.php';
require_once 'config/session.php';

// Definisikan BASE_URL jika belum didefinisikan
if (!defined('BASE_URL')) {
    define('BASE_URL', '/bri_stock_prediction');
}

// Cek status login
if (isLoggedIn()) {
    // Arahkan ke halaman dashboard
    header("Location: " . BASE_URL . "/view/dashboard/index.php");
    exit;
} else {
    // Arahkan ke halaman login
    header("Location: " . BASE_URL . "/view/auth/login.php");
    exit;
}