<?php
/**
 * Debug Login
 * File ini untuk mendiagnosis masalah login
 * Upload file ini ke root direktori website dan akses melalui browser
 */

// Mulai sesi
session_start();

// Tampilkan header
echo "<h1>Debug Informasi Login</h1>";

// Tampilkan informasi PHP
echo "<h2>Informasi PHP</h2>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>Session Save Path: " . session_save_path() . "</p>";
echo "<p>Session Name: " . session_name() . "</p>";
echo "<p>Session ID: " . session_id() . "</p>";

// Tampilkan data sesi
echo "<h2>Data Session</h2>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

// Tes menulis sesi
echo "<h2>Tes Menulis Session</h2>";
$_SESSION['test_value'] = "Test value at " . date('Y-m-d H:i:s');
echo "<p>Menulis nilai test ke session: " . $_SESSION['test_value'] . "</p>";
echo "<p>Refresh halaman ini untuk melihat apakah nilai test tetap ada</p>";

// Cek path base
echo "<h2>Path Information</h2>";
echo "<p>Document Root: " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p>Request URI: " . $_SERVER['REQUEST_URI'] . "</p>";
echo "<p>Script Name: " . $_SERVER['SCRIPT_NAME'] . "</p>";
echo "<p>PHP_SELF: " . $_SERVER['PHP_SELF'] . "</p>";

// Cek keberadaan file
echo "<h2>File Check</h2>";
$baseDir = dirname($_SERVER['SCRIPT_FILENAME']);
$filesToCheck = [
    '/config/database.php',
    '/config/session.php',
    '/controller/auth_controller.php',
    '/view/auth/login.php',
    '/view/dashboard/index.php'
];

foreach ($filesToCheck as $file) {
    $fullPath = $baseDir . $file;
    echo "<p>" . $fullPath . ": " . (file_exists($fullPath) ? "Ada" : "Tidak ada") . "</p>";
}

// Tampilkan tes login sederhana
echo "<h2>Tes Login</h2>";
echo "<form method='post'>";
echo "<p>Username: <input type='text' name='test_username' value='admin'></p>";
echo "<p>Password: <input type='password' name='test_password' value='admin123'></p>";
echo "<p><input type='submit' name='test_login' value='Test Login'></p>";
echo "</form>";

// Proses tes login
if (isset($_POST['test_login'])) {
    echo "<h3>Hasil Test Login</h3>";
    
    $username = $_POST['test_username'];
    $password = $_POST['test_password'];
    
    echo "<p>Mencoba login dengan username: " . htmlspecialchars($username) . "</p>";
    
    // Cek file database.php dan lakukan koneksi manual
    $dbFile = $baseDir . '/config/database.php';
    if (file_exists($dbFile)) {
        include_once $dbFile;
        
        if (isset($conn)) {
            echo "<p>Koneksi database berhasil!</p>";
            
            // Cek user di database
            $escapedUsername = mysqli_real_escape_string($conn, $username);
            $sql = "SELECT id, username, password FROM users WHERE username = '$escapedUsername'";
            $result = mysqli_query($conn, $sql);
            
            if ($result && mysqli_num_rows($result) > 0) {
                $user = mysqli_fetch_assoc($result);
                echo "<p>User ditemukan di database.</p>";
                
                // Verifikasi password
                if (password_verify($password, $user['password'])) {
                    echo "<p>Password benar! Autentikasi berhasil.</p>";
                    
                    // Set sesi test
                    $_SESSION['test_user_id'] = $user['id'];
                    $_SESSION['test_username'] = $user['username'];
                    
                    echo "<p>Sesi test berhasil dibuat.</p>";
                } else {
                    echo "<p>Password salah!</p>";
                    echo "<p>Password hash di database: " . $user['password'] . "</p>";
                }
            } else {
                echo "<p>User tidak ditemukan di database.</p>";
                echo "<p>Query SQL: " . $sql . "</p>";
                if ($result === false) {
                    echo "<p>Error MySQL: " . mysqli_error($conn) . "</p>";
                }
            }
        } else {
            echo "<p>Gagal membuat koneksi database!</p>";
        }
    } else {
        echo "<p>File database.php tidak ditemukan!</p>";
    }
}

// Buat password hash baru untuk admin (opsional)
echo "<h2>Generate Password Hash</h2>";
echo "<form method='post'>";
echo "<p>Password: <input type='text' name='new_password' value='admin123'></p>";
echo "<p><input type='submit' name='generate_hash' value='Generate Hash'></p>";
echo "</form>";

if (isset($_POST['generate_hash'])) {
    $newPassword = $_POST['new_password'];
    $hash = password_hash($newPassword, PASSWORD_DEFAULT);
    echo "<p>Password Hash untuk '{$newPassword}': {$hash}</p>";
    
    // Tampilkan query untuk update password
    echo "<p>Query untuk update password:</p>";
    echo "<pre>UPDATE users SET password = '{$hash}' WHERE username = 'admin';</pre>";
}