<?php
/**
 * Konfigurasi Session
 * File ini mengatur sesi user dan autentikasi
 */

// Definisikan base URL untuk redirect
define('BASE_URL', '/bri_stock_prediction');

// Memulai sesi jika belum dimulai
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Fungsi untuk memeriksa apakah user sudah login
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

// Fungsi untuk mengalihkan user yang belum login
function redirectIfNotLoggedIn() {
    if (!isLoggedIn()) {
        header("Location: " . BASE_URL . "/view/auth/login.php");
        exit;
    }
}

// Fungsi untuk mengalihkan user yang sudah login
function redirectIfLoggedIn() {
    if (isLoggedIn()) {
        header("Location: " . BASE_URL . "/view/dashboard/index.php");
        exit;
    }
}

// Fungsi untuk logout
function logout() {
    // Hapus semua variabel sesi
    $_SESSION = array();
    
    // Hapus cookie sesi
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(
            session_name(),
            '',
            time() - 42000,
            $params["path"],
            $params["domain"],
            $params["secure"],
            $params["httponly"]
        );
    }
    
    // Hancurkan sesi
    session_destroy();
    
    // Alihkan ke halaman login
    header("Location: " . BASE_URL . "/view/auth/login.php");
    exit;
}

// Fungsi untuk menyimpan pesan flash
function setFlashMessage($type, $message) {
    $_SESSION['flash'] = [
        'type' => $type,
        'message' => $message
    ];
}

// Fungsi untuk mendapatkan pesan flash
function getFlashMessage() {
    if (isset($_SESSION['flash'])) {
        $flash = $_SESSION['flash'];
        unset($_SESSION['flash']);
        return $flash;
    }
    return null;
}